/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package cds_jms_alarmsynchconsumer;

import javax.annotation.Resource;
import javax.jms.JMSConsumer;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnectionFactory;

/**
 *
 * @author alessiobechini
 */
public class AlarmSubscr {
    
    static final int MAX_INMSGNUM =10;
    
    @Resource(lookup = "jms/__defaultConnectionFactory")
    private static TopicConnectionFactory tcf;
    @Resource(lookup = "jms/alarms")
    private static Topic topic;
    
    //a JMSContxt is used instead of connection+session
    private JMSContext jmscontext;
    private JMSConsumer consumer;

    public AlarmSubscr() {
        try{
            jmscontext=tcf.createContext(JMSContext.AUTO_ACKNOWLEDGE);
            consumer=jmscontext.createConsumer(topic);
        }
        catch(Exception e){           
        }
    }


    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        AlarmSubscr alarmSub= new AlarmSubscr();
        for(int i=0;i<MAX_INMSGNUM; i++){
            String msg = alarmSub.await();
            System.out.println("Message text: "+msg+"\n");
        }
    }
    
    public String await() {
        try{
            System.out.println("Going to receive...");
            TextMessage txtMsg = (TextMessage)consumer.receive();
            System.out.println("Received!");
            return txtMsg.getText();
        }
        catch(JMSException e){
            return null;
        }
    }
    
}
