/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package cds_jms_alarmproducer;

import javax.jms.*; 
import javax.naming.*;

/**
 *
 * @author alessiobechini
 */
public class AlarmProducer {
    
    static final int MAX_MSGNUM = 6;
    static final int MAX_MSGWAIT = 4000; //in msecs 

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        AlarmProducer alarmObj= new AlarmProducer();
        alarmObj.raise(MAX_MSGNUM);
    }
    
    public void raise(int maxnum) {
        try{
            Context ic = new InitialContext();
            TopicConnectionFactory tcf = (TopicConnectionFactory)ic.lookup("jms/__defaultConnectionFactory");
            Topic topic = (Topic)ic.lookup("jms/alarms");
            TopicConnection tc = tcf.createTopicConnection();
            TopicSession ts = tc.createTopicSession(false, Session.AUTO_ACKNOWLEDGE);
            TopicPublisher tpub = ts.createPublisher(topic);
            for(int i=0; i<maxnum; i++){
                System.out.println("Attempting to send msg # "+Integer.toString(i));
                TextMessage txt = ts.createTextMessage("Alarm # "+Integer.toString(i));
                tpub.publish(txt);
                System.out.println(txt.getText());
                Thread.sleep(new java.util.Random().nextInt(MAX_MSGWAIT));
            }
        }
        catch(NamingException | JMSException | InterruptedException e){
            
        }
    }
    
}
