#include "struct_tabella.h"
#include <iostream>
#include <cstring>
#include <cstdlib>
using namespace std;

void init(Tabella& tab) {
	tab.quanti = 0;
}

void visualizza(const Tabella& tab) {
	cout<<tab.quanti<<" atleti iscritti:"<<endl;
	for(int i=0; i<tab.quanti; i++) {
		cout<<tab.atl[i].nome<<" "<<tab.atl[i].pettorale<<endl;
	}
	cout<<endl;
}

bool aggiungi(Tabella& tab, const char* nome, int pettorale) {
	//controlle se la tabella e' piena
	if(tab.quanti>=MAX) { return false; }
	//controllo se nome o pettorale sono gia' inseriti nella tabella
	for(int i=0; i<tab.quanti; i++) {
		if(strcmp(tab.atl[i].nome, nome)==0 || tab.atl[i].pettorale == pettorale) { return false; }
	}
	//inserisco nome e pettorale
	strcpy(tab.atl[tab.quanti].nome, nome);
	tab.atl[tab.quanti].pettorale = pettorale;
	tab.quanti++;
	return true;
}

bool elimina(Tabella& tab, const char* nome) {
	for(int i=0; i<tab.quanti; i++) {
		if(strcmp(tab.atl[i].nome, nome) == 0) {
			if(tab.quanti > 1) {
				//sovrascrivo nome e pettorale con quelli di un altro atleta (l'ultimo elencato nella tabella)
				tab.atl[i] = tab.atl[tab.quanti-1];
			}
			tab.quanti--;
			return true;
		}
	}
	return false;
}

int cerca(const Tabella& tab, const char* nome) {
	for(int i=0; i<tab.quanti; i++) {
		if(strcmp(tab.atl[i].nome, nome) == 0) {
			return tab.atl[i].pettorale;
		}
	}
	return -1;
}
