#include "class_tabella.h"
#include <iostream>
#include <cstring>
#include <cstdlib>
using namespace std;

void Tabella::init() {
	quanti = 0;
}

void Tabella::visualizza() {
	cout<<quanti<<" atleti iscritti:"<<endl;
	for(int i=0; i<quanti; i++) {
		cout<<atl[i].nome<<" "<<atl[i].pettorale<<endl;
	}
	cout<<endl;
}

bool Tabella::aggiungi(const char* nome, int pettorale) {
	//controlle se la tabella e' piena
	if(quanti>=MAX) { return false; }
	//controllo se nome o pettorale sono gia' inseriti nella tabella
	for(int i=0; i<quanti; i++) {
		if(strcmp(atl[i].nome, nome)==0 || atl[i].pettorale == pettorale) { return false; }
	}
	//inserisco nome e pettorale
	strcpy(atl[quanti].nome, nome);
	atl[quanti].pettorale = pettorale;
	quanti++;
	return true;
}

bool Tabella::elimina(const char* nome) {
	for(int i=0; i<quanti; i++) {
		if(strcmp(atl[i].nome, nome) == 0) {
			if(quanti > 1) {
				//sovrascrivo nome e pettorale con quelli di un altro atleta (l'ultimo elencato nella tabella)
				atl[i] = atl[quanti-1];
			}
			quanti--;
			return true;
		}
	}
	return false;
}

int Tabella::cerca(const char* nome) {
	for(int i=0; i<quanti; i++) {
		if(strcmp(atl[i].nome, nome) == 0) {
			return atl[i].pettorale;
		}
	}
	return -1;
}
