
#define SWISPOTVERSION "0.2.3"

#define HELPSTRING "Usage: SwiSpot -s sequence [-t temperature] [-o output] [-c confpath] [-n number of structures] [-pvlh]\n\n"\
"SwiSpot is a command line utility for predicting riboswitch alternative\n"\
"configurations. It is based upon the prediction of the so-called switching\n"\
"sequence, to subsequently constrain the folding of the two functional structures.\n"\
"While theoretically able to find any kind of switching behavior, under the\n"\
"assumption of sufficient representation in the ensemble of structures,\n"\
"currently SwiSpot is able to classify only riboswitches that rely on \n"\
"transcription termination via terminator hairpins, or translation inhibition\n"\
"via SD sequestering/releasing.\n\n"\
"OPTIONS: \n"\
"\t-s\t--sequence\t\tSequence to be analyzed. Mandatory argument.\n\n"\
"\t-h\t--help\t\t\tPrint help and exit \n\n"\
"\t-t\t--temperature\t\tRescale energy parameters to a temperature of temp C. Default is 37C. \n\n"\
"\t-n\t--numstruct\t\tNumber of structure used in the sampling procedure. \n\n"\
"\t-p\t--probability\t\tUse probability matrix instead of sampled ensemble. \n\n"\
"\t-o\t--output\t\tWrite output to file. \n\n"\
"\t-c\t--confpath\t\tConfiguration file path.\n\n"\
"\t-l\t--logging\t\tTurn verbosity on. \n\n"\
"\t-v\t--version\t\tPrint version and exit.\n"

/*
 * FUNCTION PROTOTYPES
 * 
 */
void scoreBP(int nMin, int nMax, int N, float **board, double **matrix, int sp, int sn);

void findMax(int* winI, int* kI, int M, int N, float **board);

double **distMatrix(int N,char **structures);

void terminatorEvaluator(char *sequence, char *structure1, char *structure2, int N, float *iT);

void termIndex(char *sequence, char *structure,int N,float *iT);

void SDEvaluator(char *sequence, char *structure1, char *structure2, int N, float *iSD);

void SDIndex(char *sequence, char *structure,int N,float *iSD);

void scoreEnsemble(int nMin, int nMax, int N,int eN, float **board, char **structures, int sp, int sn);

void silhuoette_score2clust(int *clustid, double** distMat, int N, float *silScore);

int verifySequence(char *sequence,int len);
