# SwiSpot

SwiSpot is a command line utility for predicting riboswitch alternative
configurations. It is based upon the prediction of the so-called switching
sequence, to subsequently constrain the folding of the two functional structures.
While theoretically able to find any kind of switching behaviour, under the
assumption of sufficient representation in the ensemble of structures,
currently SwiSpot is able to classify only riboswitches that rely on
transcription termination via terminator hairpins, or translation inhibition
via SD sequestering/releasing.

## Dependencies

Compiled version of ViennaRNA library must be linked at compile time.
Tested with ViennaRNA 2.1.9. Library path must be linked in CMakeLists.txt
under the \# Library Path section. ViennaRNA library header path must be
given under the include_directory(  ... ) in CMakeLists.txt.
ViennaRNA can be installed from [Vienna TBI](http://www.tbi.univie.ac.at/RNA/)
```
 tar -zxvf ViennaRNA-2.1.9.tar.gz
 cd ViennaRNA-2.1.9
 ./configure
 make
```
optional
```
 sudo make install
```

Mac OS X user can install ViennaRNA using homebrew:
```
brew install ViennaRNA
```


## Installation


 Unpack cmdline-SwiSpot-x.y.z.tar.gz
```    
tar -zxvf cmdline-SwiSpot-x.y.z.tar.gz
```
 Enter directory  
```    
cd cmdline-SwiSpot-x.y.z
mkdir build
cd build
```
 Install
```    
cmake -G "Unix Makefiles" ../
make
make instal
```


## Usage:
  Usage: SwiSpot -s sequence [-t temperature] [-o output] [-n number of structure ] [-pvlh]

  SwiSpot is a command line utility for predicting riboswitch alternative
  configurations. It is based upon the prediction of the so-called switching
  sequence, to subsequently constrain the folding of the two functional structures.
  While theoretically able to find any kind of switching behavior, under the
  assumption of sufficient representation in the ensemble of structures,
  currently SwiSpot is able to classify only riboswitches that rely on
  transcription termination via terminator hairpins, or translation inhibition
  via SD sequestering/releasing.

  OPTIONS:
	  -s	   --sequence		  Sequence to be analyzed. Mandatory argument.

	  -h	   --help			  Print help and exit

	  -t	   --temperature	  Rescale energy parameters to a temperature of temp C. Default is 37C.

	  -n	   --numstruct		  Number of structure used in the sampling procedure.

	  -p	   --probability	  Use probability matrix instead of sampled ensemble.

	  -o	   --output		      Write output to file.
	  
	  -c	   --confpath		  Configuration file path.

	  -l	   --logging		  Turn verbosity on.

	  -v	   --version		  Print version and exit.

## Configuration file
Configuration file, must be placed somewhere and specified by the option -c  
```
#Some comments
sp=1.0
sn=-0.9
```

## Changelog

###0.2.3
- Bugfixes

### 0.2.2
- Some modification to SD evaluation

### 0.2.1
- Configuration file introduced

### 0.2.0
- Completely translated to ansi C.


## TODO

- [ ] More metrics (string-edit distance, tree-edit distance,...)
- [ ] Extended sampling using RNA melting temperature.
