
package my.jms.webpublishing;

import java.io.IOException;
import javax.jms.*;
import javax.naming.*;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


public class PublisherServlet extends HttpServlet {
    
    //the following shold be put as servlet config parameters!
    static final String TC_FACTORY_NAME = "jms/__defaultConnectionFactory";
    static final String TOPIC_NAME = "jms/myTopic";


    /**
     * Processes requests for both HTTP <code>GET</code> and <code>POST</code>
     * methods.
     *
     * @param request servlet request
     * @param response servlet response
     * @throws ServletException if a servlet-specific error occurs
     * @throws IOException if an I/O error occurs
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        response.setContentType("text/html;charset=UTF-8");
        
        
        String msg = request.getParameter("msg");
        if (msg!=null) {
            msg=msg.trim();
            if (!msg.equals("")){
                try {
                    Context ic = new InitialContext();
                    TopicConnectionFactory tcf = (TopicConnectionFactory)ic.lookup(TC_FACTORY_NAME);
                    Topic topic = (Topic)ic.lookup(TOPIC_NAME);
                    TopicConnection tc = tcf.createTopicConnection();
                    TopicSession ts = tc.createTopicSession(false, Session.AUTO_ACKNOWLEDGE);
                    TopicPublisher tpub = ts.createPublisher(topic);

                    TextMessage txt = ts.createTextMessage("from Web -> "+msg);
                    tpub.publish(txt);

                }
                catch (NamingException | JMSException e){
                    System.err.println("OUTCH! WEB PUBLISHING PROBLEMS!");
                    System.err.println(e.getMessage());
                }
            }
        }
        
        String indexPage="/index.html";    
        javax.servlet.RequestDispatcher disp = getServletContext().getRequestDispatcher(indexPage);

        if (disp != null) disp.forward(request, response);
        
    }

    // <editor-fold defaultstate="collapsed" desc="HttpServlet methods. Click on the + sign on the left to edit the code.">
    /**
     * Handles the HTTP <code>GET</code> method.
     *
     * @param request servlet request
     * @param response servlet response
     * @throws ServletException if a servlet-specific error occurs
     * @throws IOException if an I/O error occurs
     */
    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        processRequest(request, response);
    }

    /**
     * Handles the HTTP <code>POST</code> method.
     *
     * @param request servlet request
     * @param response servlet response
     * @throws ServletException if a servlet-specific error occurs
     * @throws IOException if an I/O error occurs
     */
    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        processRequest(request, response);
    }

    /**
     * Returns a short description of the servlet.
     *
     * @return a String containing servlet description
     */
    @Override
    public String getServletInfo() {
        return "Short description";
    }// </editor-fold>

}
