
package my.jms.subscribing;

import javax.annotation.*;
import javax.jms.*;


public class Subscriber {
    
    static final String TC_FACTORY_NAME = "jms/__defaultConnectionFactory";
    static final String TOPIC_NAME = "jms/myTopic";

    static final int MAX_INMSGNUM =-1; //a negative number means "unbounded"
    
    @Resource(lookup = TC_FACTORY_NAME)
    private static TopicConnectionFactory tcf;
    @Resource(lookup = TOPIC_NAME)
    private static Topic topic;
    
    //a JMSContxt is used instead of connection+session
    private JMSContext jmscontext;
    private JMSConsumer msgConsumer;

    public Subscriber(){
        try {
            jmscontext = tcf.createContext(JMSContext.AUTO_ACKNOWLEDGE);
            msgConsumer = jmscontext.createConsumer(topic);
        }
        catch(Exception e){ 
            System.err.println("OUTCH! Problems in instantiating the Subscriber!");
            System.err.println(e.getMessage());
        }
    }

    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        Subscriber alarmSub= new Subscriber();
        for(int i=0;i!=MAX_INMSGNUM; i++){
            String msg = alarmSub.await();
            System.out.println("Message text: "+msg+"\n");
        }
    }
    
    public String await() {
        try{
            System.out.print("Going to receive... ");
            TextMessage txtMsg = (TextMessage)msgConsumer.receive();
            System.out.println("Received!");
            return txtMsg.getText();
        }
        catch(JMSException e){
            return null;
        }
    }

    
}
