
package my.jms.publishing;

import javax.jms.*;
import javax.naming.*;



public class Publisher {
    
    static final String TC_FACTORY_NAME = "jms/__defaultConnectionFactory";
    static final String TOPIC_NAME = "jms/myTopic";
    static final int MAX_MSGNUM = 6;
    static final int MAX_MSGWAIT = 4000; //in msecs 


    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        Publisher alarmObj= new Publisher();
        alarmObj.raise(MAX_MSGNUM);
    }
    
    public void raise(int maxnum) {
        try{
            Context ic = new InitialContext();
            TopicConnectionFactory tcf = (TopicConnectionFactory)ic.lookup(TC_FACTORY_NAME);
            Topic topic = (Topic)ic.lookup(TOPIC_NAME);
            TopicConnection tc = tcf.createTopicConnection();
            TopicSession ts = tc.createTopicSession(false, Session.AUTO_ACKNOWLEDGE);
            TopicPublisher tpub = ts.createPublisher(topic);
            for(int i=0; i<maxnum; i++){
                System.out.println("Attempting to send msg # "+Integer.toString(i));
                TextMessage txt = ts.createTextMessage("Alarm # "+Integer.toString(i));
                tpub.publish(txt);
                System.out.println(txt.getText());
                Thread.sleep(new java.util.Random().nextInt(MAX_MSGWAIT));
            }
        }
        catch(NamingException | JMSException | InterruptedException e){
            System.err.println("OUTCH! PUBLISHING PROBLEMS!");
            System.err.println(e.getMessage());
            
        }
    }
    
}
