
package my.jms.listener;

import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.jms.*;


@MessageDriven(activationConfig = {
    @ActivationConfigProperty(propertyName = "clientId", propertyValue = "jms/myTopic"),
    @ActivationConfigProperty(propertyName = "destinationLookup", propertyValue = "jms/myTopic"),
    //@ActivationConfigProperty(propertyName = "subscriptionDurability", propertyValue = "durable"),
    @ActivationConfigProperty(propertyName = "subscriptionName", propertyValue = "jms/myTopic"),
    @ActivationConfigProperty(propertyName = "destinationType", propertyValue = "javax.jms.Topic")
})
public class ListenerMsgBean implements MessageListener {
    
    public ListenerMsgBean() {
    }
    
    
    @Override
    public void onMessage(Message message) {
        try {
            TextMessage txt = (TextMessage)message;
            System.out.println("from thr EJB listener: "+ txt.getText());
        } catch (JMSException ex) {
            System.err.println("OUTCH! Something bad happened at onMessage()!");
            System.err.println(ex.getMessage());
        }
    }

    
}
